/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.UUID;

public class SystemInfo {
    private final String os = System.getProperty("os.name");
    private final String osVersion = System.getProperty("os.version");
    private final String username = System.getProperty("user.name");
    private final String javaVersion = System.getProperty("java.version");
    private final String macAddress = this.readMacAddress();
    private final String cpuId = this.readCpuId();
    private final String machineId = this.generateMachineId();
    private final File appDirectory = this.initAppDirectory();

    public String getOs() {
        return this.os;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getCpuId() {
        return this.cpuId;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public File getAppDirectory() {
        return this.appDirectory;
    }

    public String getNow() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
    }

    private boolean isWindows() {
        return this.os.toLowerCase().contains("win");
    }

    private boolean isLinux() {
        return this.os.toLowerCase().contains("linux");
    }

    private File initAppDirectory() {
        Path dir = Paths.get(System.getProperty("user.home"), ".talpie-home");
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return dir.toFile();
    }

    private String readMacAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(ip);
            if (ni == null) {
                return "unknown";
            }
            byte[] mac = ni.getHardwareAddress();
            if (mac == null) {
                return "unknown";
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : mac) {
                sb.append(String.format("%02X:", b));
            }
            return sb.substring(0, sb.length() - 1);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private String readCpuId() {
        try {
            if (this.isWindows()) {
                return this.exec("wmic cpu get ProcessorId");
            }
            if (this.isLinux()) {
                return this.exec("cat /proc/cpuinfo | grep Serial || echo unknown");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private String generateMachineId() {
        String base = this.username + this.macAddress + this.cpuId + this.os + this.osVersion;
        UUID namespace = UUID.nameUUIDFromBytes("TALPIE-HOME".getBytes(StandardCharsets.UTF_8));
        return this.generateUUIDv5(namespace, base).toString();
    }

    private String exec(String command) {
        try {
            String line;
            Process process = this.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.toLowerCase().contains("processorid")) continue;
                output.append(line);
            }
            process.waitFor();
            return output.toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private UUID generateUUIDv5(UUID namespace, String name) {
        try {
            byte[] nsBytes = this.toBytes(namespace);
            byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
            byte[] all = new byte[nsBytes.length + nameBytes.length];
            System.arraycopy(nsBytes, 0, all, 0, nsBytes.length);
            System.arraycopy(nameBytes, 0, all, nsBytes.length, nameBytes.length);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(all);
            hash[6] = (byte)(hash[6] & 0xF);
            hash[6] = (byte)(hash[6] | 0x50);
            hash[8] = (byte)(hash[8] & 0x3F);
            hash[8] = (byte)(hash[8] | 0x80);
            return UUID.nameUUIDFromBytes(Arrays.copyOf(hash, 16));
        }
        catch (Exception e) {
            return UUID.randomUUID();
        }
    }

    private byte[] toBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }
}

