/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.ClientHandler;
import com.talpie.linker.DataSocketServer;
import com.talpie.linker.Message;
import com.talpie.linker.ServerListeners;
import com.talpie.linker.TransferStats;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ServerStatsListener
implements ServerListeners.ControlMessage,
ServerListeners.DataMessage,
ServerListeners.Progress {
    private final TransferStats total = new TransferStats();
    private final ConcurrentHashMap<String, TransferStats> perClient = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> txMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> rxMap = new ConcurrentHashMap();

    private static String routeOf(Message m) {
        return m != null ? m.getRoute() : "";
    }

    private TransferStats S(ClientHandler ch) {
        return this.perClient.computeIfAbsent(ch.getClientId(), k -> new TransferStats());
    }

    @Override
    public Message onRequest(Object c, Timestamp ts, ClientHandler ch, Message m) {
        this.total.onMsgRx(ServerStatsListener.routeOf(m));
        this.S(ch).onMsgRx(ServerStatsListener.routeOf(m));
        return null;
    }

    @Override
    public Message onResponse(Object c, Timestamp ts, ClientHandler ch, Message m) {
        this.total.onMsgRx(ServerStatsListener.routeOf(m));
        this.S(ch).onMsgRx(ServerStatsListener.routeOf(m));
        return null;
    }

    @Override
    public Message onRequest(Object c, Timestamp ts, ClientHandler ch, DataSocketServer ds, Message m) {
        this.total.onMsgRx(ServerStatsListener.routeOf(m));
        this.S(ch).onMsgRx(ServerStatsListener.routeOf(m));
        return null;
    }

    @Override
    public Message onResponse(Object c, Timestamp ts, ClientHandler ch, DataSocketServer ds, Message m) {
        this.total.onMsgRx(ServerStatsListener.routeOf(m));
        this.S(ch).onMsgRx(ServerStatsListener.routeOf(m));
        return null;
    }

    @Override
    public void onProgressTransmitting(Object c, Timestamp ts, ClientHandler ch, Message m, long sent, long totalBytes, int pct) {
        long prev = this.txMap.getOrDefault(m.getMessageId(), 0L);
        long delta = Math.max(0L, sent - prev);
        if (delta > 0L) {
            this.total.onBytesTx(ServerStatsListener.routeOf(m), delta, true);
            this.S(ch).onBytesTx(ServerStatsListener.routeOf(m), delta, true);
            this.txMap.put(m.getMessageId(), sent);
        }
        if (sent >= totalBytes) {
            this.txMap.remove(m.getMessageId());
        }
    }

    @Override
    public void onProgressReceiving(Object c, Timestamp ts, ClientHandler ch, Message m, long rec, long totalBytes, int pct) {
        long prev = this.rxMap.getOrDefault(m.getMessageId(), 0L);
        long delta = Math.max(0L, rec - prev);
        if (delta > 0L) {
            this.total.onBytesRx(ServerStatsListener.routeOf(m), delta, true);
            this.S(ch).onBytesRx(ServerStatsListener.routeOf(m), delta, true);
            this.rxMap.put(m.getMessageId(), rec);
        }
        if (rec >= totalBytes) {
            this.rxMap.remove(m.getMessageId());
        }
    }

    @Override
    public void onProgressDataTransmitting(Object c, Timestamp ts, ClientHandler ch, DataSocketServer ds, Message m, long s, long t, int p) {
        this.onProgressTransmitting(c, ts, ch, m, s, t, p);
    }

    @Override
    public void onProgressDataReceiving(Object c, Timestamp ts, ClientHandler ch, DataSocketServer ds, Message m, long r, long t, int p) {
        this.onProgressReceiving(c, ts, ch, m, r, t, p);
    }

    public TransferStats totals() {
        return this.total;
    }

    public Map<String, TransferStats> perClient() {
        return Collections.unmodifiableMap(this.perClient);
    }

    public void onMsgTx(ClientHandler ch, String route) {
        this.total.onMsgTx(route);
        this.S(ch).onMsgTx(route);
    }

    public void onMsgRx(ClientHandler ch, String route) {
        this.total.onMsgRx(route);
        this.S(ch).onMsgRx(route);
    }
}

